#!/bin/bash
set -exo pipefail

status_file=$1
status_file_time_mark=${status_file}.tmp

if [ -f $status_file ]
then
    status_file_date="$(stat -c %y $status_file 2>/dev/null|cut -d' ' -f1)"
    touch $status_file_time_mark
    now_date="$(stat -c %y $status_file_time_mark 2>/dev/null|cut -d' ' -f1)"
    if [ x"$status_file_date" == x"$now_date" ]
    then
        mode="--incremental"
    else
        mode="--full"
    fi
else
    mkdir -p $(dirname $status_file)
    touch $status_file
    mode="--incremental"
fi

if $(dirname $0)/logrotate_incremental.sh $mode
then
    echo "Logrotate successful, touching $status_file"
    if [ -f $status_file_time_mark ]
    then
        mv $status_file_time_mark $status_file
    fi
else
    >&2 echo "Logrotate failed, leaving $status_file untouched"
    rm -f $status_file_time_mark
fi

