#!/bin/bash
set -x
REQUEST_TIMEOUT=${REQUEST_TIMEOUT:-3}
SCHEME=${SCHEME:-http}
URL="$SCHEME://localhost:$PORT/status?verbose=false&json-type=normal"
while true
do
    status=$(curl $CURL_OPTS -sm $REQUEST_TIMEOUT "$URL&watchdog-$(date +%T.%N)")
    if echo "$status" | jq . | fgrep -q '"status"'
    then
        if echo "$status" | jq . | fgrep '"status"' | fgrep -qv '"ACTIVE"'
        then
            >&2 echo Some clients are dead:
            echo "$status" | jq -M . >&2
            exit 1
        else
            exit 0
        fi
    elif [ -n "$FAIL_FAST_EXIT_CODE" ]
    then
        exit $FAIL_FAST_EXIT_CODE
    fi
    sleep 1
done

