#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Script exiting with "1" error code if configuration doesn't matching current FINISHED nanny configuration. 
# Otherwise (if executing error, or status is ACTIVATING) exiting with 0.
# For details see https://st.yandex-team.ru/PS-2548

import json
import urllib2
import time
import sys
import os

print "WARNING! CHECK ITS STATUS TEMPORARY DISABLED!!!! until PS-3659 is done. Do nothing and continue."
sys.exit(0)

ITS_URL = "http://its.yandex-team.ru/v1/process/"

TRIES = 2
SLEEP = 5
PROPERTIES_FILE = "metainstance.json"

SPECIAL_TAG = os.environ['NANNY_SERVICE_ID']

def make_auth_req_post(url, data, token=None):
    request = urllib2.Request(url)
    request.add_header('Content-Type', 'application/json')
    if token:
        request.add_header("Authorization", "OAuth {0}".format(token))
    attempts = 0
    while attempts < TRIES:
        try:
            result = urllib2.urlopen(request, json.dumps(data), timeout=20)
            break
        except Exception as e:
            attempts +=1
            print("Error reached {0} Url: {2} Retry count:{1}".format(e, attempts, url))
            time.sleep(SLEEP)
            if attempts == TRIES:
                print("Timeout!")
                raise Exception("Timeout exception!")
    return result.read()

def get_json(filename):
    try:
        with open(filename, 'r') as f:
            return json.loads("".join(f.readlines()))
    except IOError:
        return None

if __name__ == "__main__":
    try:
        prop_dict = get_json(PROPERTIES_FILE)
        # See available location tags for personalsearch -  https://nanny.yandex-team.ru/ui/#/its/config/edit/locations/personalsearch/
        tags_list = prop_dict['leader']['properties']['tags'].split(" ")
        tags_list.append(SPECIAL_TAG)

        its_answer = json.loads(make_auth_req_post(ITS_URL, tags_list))
        # Example its_answer: {"./personal_search_conf_version": "FINISHED:mail_search_prestable-1500490785320"}

        curr_conf_id = prop_dict['leader']['configurationId'].split("#")[1]

        status=its_answer['./personal_search_conf_version'].split(":")[0]
        nanny_conf_id=its_answer['./personal_search_conf_version'].split(":")[1]

        if status == 'FINISHED':
            if curr_conf_id != nanny_conf_id:
                print "ERROR! Current conf id: {0} Nanny conf id: {1}".format(curr_conf_id, nanny_conf_id)
                sys.exit(1)
            else:
                print "ALL OK. Current conf id: {0} Nanny conf id: {1}".format(curr_conf_id, nanny_conf_id)
                sys.exit(0)
        else:
            print "Status is ACTIVATING (not FINISHED), exit notmally"
            sys.exit(0)
    except Exception as e:
        print "Executing exception reached: {0}, exit normally".format(e)
        sys.exit(0)

