#!/bin/bash
set -exo pipefail

#first - check that index was copied before launch another status scripts, do not check copyness for watchdog
if [ "$LABELS_deploy_engine" = "YP_LITE" ] && [ ! "$1" = "PASS_COPY_CHECK" ]
then
    >&2 echo "$(date) Starting pre-start check requests. Check index and copier status."

    has_copy_jobs_checked=0
    for has_copy_jobs in $(curl -sm 5 "localhost:$INDEXER_PORT/stat" | jq -r '.[] | select(.[0] | endswith("has-copy-jobs_ammt"))[1]')
    do
        >&2 echo "$(date) Has copy jobs stat request complete. has-copy-jobs_ammt = $has_copy_jobs"

        if [ "$has_copy_jobs" == "0" ]
        then
            >&2 echo "$(date) Copier was not started and copy jobs isn't specified. Wait for copier."
            sleep 60
            exit 1
        else
            >&2 echo "$(date) Copier was started. Go to checking index copy perc stat."
            has_copy_jobs_checked=1
        fi
    done

    if [ "$has_copy_jobs_checked" == "0" ]
    then
        >&2 echo "$(date) Cannot get has_copy_jobs_checked data, exiting"
        exit 1
    fi

    index_perc_checked=0
    for index_perc in $(curl -sm 5 "localhost:$INDEXER_PORT/stat" | jq -r '.[] | select(.[0] | endswith("index-copy-progress_perc_annt"))[1]')
    do
        >&2 echo "$(date) Index stat request complete. index-copy-progress_perc_annt = $index_perc"

        if [ "$index_perc" == "100" ]
        then
            >&2 echo "$(date) Index copying was completed. Continue stat checks."
            index_perc_checked=1
        else
            >&2 echo "$(date) Index copying was not completed. Exit with error, wait for copynig complete."
            sleep 30
            exit 1
        fi
    done

    if [ "$index_perc_checked" == "0" ]
    then
        >&2 echo "$(date) Cannot get index_perc data, exiting"
        sleep 30
        exit 1
    fi

    has_halted_shards=$(curl -sm 5 "localhost:$CONSUMER_PORT/stat" | jq -r '.[] | select(.[0] | endswith("has-halted-shards_ammx"))[1]')
    >&2 echo "$(date) Halted stat request complete. has-halted-shards_ammx = $has_halted_shards"

    if [ -z "$has_halted_shards" ]
    then
        >&2 echo "$(date) Checking halted shards stat request was failed, zero status returns. Is there port issue? Exiting with error."
        exit 1
    fi
    if [ "$has_halted_shards" != "0" ]
    then
        >&2 echo "$(date) Halted shards found. Exit with error, wait for meat bag to fix this issue."
	exit 1
    else
        >&2 echo "$(date) No halted shards found."
    fi
fi

