#!/bin/bash
set -ex pipefail

# walk through all referenced env.vars (in the given file) and substitute ones by its values (it replaces the file in place)
substitute_vars() {
    local file_path=$1
    for v in $(grep -ohE '\$\(\w+\)' $file_path | grep -ohE '\w+' | sort -u); do
        [ -z "$v" ] && continue
        eval val=\$$v
        sed -i "s#\$($v)#$val#g" $file_path
    done
}

# substitutes all includes by its content in place (in the given file)
substitute_includes() {
    local file_path=${HOME_DIR}/$1
    for v in "$(grep -ohE '\$\(include [^ ()]+?\)' $file_path | grep -ohE 'include [^ ()]+?')"; do
        config_file=$(echo $v | sed -e 's/^include //')
        if [ -z "$config_file" -o ! -e "$config_file" ]; then
            sed -i "s#\$($v)##g" $file_path
            echo "File '$config_file' does not exist!"
            continue
        fi
        temp_file=$(mktemp)
        perl -e "open (FH, '<', \"$file_path\"); while (<FH>) { if (m|\\$\($v\)|) { open (FH2, '<', \"$config_file\"); print <FH2>, \"\n\" } else {print $_}}" > $temp_file
        mv -f $temp_file $file_path
        rm -f $temp_file
    done
}

# do calculations of expressions (in the given file) and replace latter by result of first
calc_expressions() {
    local file_path=$1
    for v in $(grep -ohE '\$\([^\$\(\)]+?\)' $file_path | grep -ohE '[^\$\(\)]+' | sort -u); do
        val=$(( $v ))
        sed -i "s#\$($v)#$val#g" $file_path
    done
}
