#!/bin/bash

set -exo pipefail

export MKL_DOMAIN_NUM_THREADS="MKL_DOMAIN_ALL=1; MKL_DOMAIN_BLAS=1; MKL_DOMAIN_FFT=1"
export MKL_DYNAMIC=FALSE
export MKL_NUM_THREADS=1
export OMP_DYNAMIC=FALSE
export OMP_NUM_THREADS=1
export OMP_SCHEDULE="static,1"

if ./cpu_id HaveAVX2
then
    export MKL_ENABLE_INSTRUCTIONS=AVX2
fi

if ./cpu_id IsAMD
then
    if test -z $MKL_CBWR
    then
        if ./cpu_id HaveAVX2
        then
            export MKL_DEBUG_CPU_TYPE=5
        elif ./cpu_id HaveAVX
        then
            export MKL_DEBUG_CPU_TYPE=4
        fi
    fi
fi

