#!/bin/bash

CPU_CORES_CORRECTION=${CPU_CORES_CORRECTION:-"0.2"}
if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk -v cores="$CPU_CORES_CORRECTION" '{print int($1 + cores)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk -v cores="$CPU_CORES_CORRECTION" '{print int($1 + cores)}')
fi

if [ "$MEM_LIMIT" != "" ]; then
    export MEMORY_LIMIT=$((MEM_LIMIT/100*80))
else
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | awk '{print int($1*0.8)}')
fi

if [ "$MEMORY_LIMIT" = "0" ]; then
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["memory_guarantee"]' | awk '{print int($1*0.8)}')
fi