#!/bin/bash
# By default we dst=src
set -x

function version { echo "$@" | awk -F. '{ printf("%d%03d%03d%03d\n", $1,$2,$3,$4); }'; }

TVMID_ENV=${TVMID_ENV:-"TVM_CLIENT_ID"}
TVMSECRET_ENV=${TVMSECRET_ENV:-"SECRET"}
JAVA_PID=$(ps aux | grep java | grep -v grep | awk '{print $2}')
TVM_CLIENT_ID=$(cat /proc/$JAVA_PID/environ | tr '\0' '\n' | egrep -o "^$TVMID_ENV\=([0-9]+)" | cut -d'=' -f2)
SECRET=$(cat /proc/$JAVA_PID/environ | tr '\0' '\n' | egrep -o "^$TVMSECRET_ENV=[0-9a-z_A-Z\\\-]+" | cut -d'=' -f2)

DEST_TVM_ID=${DEST_TVM_ID:-$TVM_CLIENT_ID}
KNIFE_VERSION=$(dpkg -s yandex-passport-tvmknife | grep Version | cut -d ':' -f2 | tr -d ' ')
if [ $(version "$KNIFE_VERSION") -gt $(version "2.5.0") ];
then
   TICKET=$(echo $SECRET | tvmknife get_service_ticket client_credentials -s ${TVM_CLIENT_ID} -d ${DEST_TVM_ID} -S)
else
   TICKET=$(tvmknife get_service_ticket client_credentials -s ${TVM_CLIENT_ID} -d ${DEST_TVM_ID} -S $SECRET)
fi
curl -H "X-Ya-Service-Ticket: $TICKET" "$@"
