#!/bin/bash

set -exo pipefail

if [ -n "$1" ]; then
  source $1
fi

# check tvm client id
if [ -z "${PUSH_CLIENT_TVM_CLIENT_ID}" ]; then
  export PUSH_CLIENT_TVM_CLIENT_ID=${TVM_CLIENT_ID}
fi

if [ -z "${PUSH_CLIENT_TVM_CLIENT_ID}" ]; then
  exit 1
fi

#prod https://abc.yandex-team.ru/services/Logbroker/resources/?tag=2&supplier=14&type=47&state=requested&state=approved&state=granted&view=consuming
export PUSH_CLIENT_TVM_SERVER_ID=2001059
# check tvm secret
if [ -z "${PUSH_CLIENT_TVM_SECRET}" ]; then
  export PUSH_CLIENT_TVM_SECRET=${SECRET}
fi

# check topic
if [ -z "${PUSHCLIENT_DEFAULT_TOPIC}" ]; then
  if [ -n "${PS_ABCSERVICE}" ] && [ -n "${PS_PROJECT}" ]; then
    export PUSHCLIENT_DEFAULT_TOPIC="/$PS_ABCSERVICE/${PS_PROJECT}-access-log"
  fi
fi

if [ -z "${PUSHCLIENT_DEFAULT_TOPIC}" ]; then
  exit 1
fi

# check logname
if [ -z "${PUSHCLIENT_DEFAULT_LOG_NAME}" ]; then
  if [ -n "${PS_ABCSERVICE}" ] && [ -n "${PS_PROJECT}" ]; then
    export PUSHCLIENT_DEFAULT_LOG_NAME="/logs/${PS_PROJECT}-access-json.log"
  fi
fi

if [ -z "${PUSHCLIENT_DEFAULT_LOG_NAME}" ]; then
  exit 1
fi

chmod +x ./push-client
cp pushclient_default.template pushclient_default.conf
sed -i "s/%LOG_NAME%/$(echo ${PUSHCLIENT_DEFAULT_LOG_NAME} | sed -e 's/\//\\\//g')/g" pushclient_default.conf
sed -i "s/%TOPIC%/$(echo ${PUSHCLIENT_DEFAULT_TOPIC} | sed -e 's/\//\\\//g')/g" pushclient_default.conf

for ((i = 1; 1; i++)); do
  TOPIC_VAR="PUSHCLIENT_TOPIC_$i"
  LOG_VAR="PUSHCLIENT_LOG_NAME_$i"
  if [ -z "${!TOPIC_VAR}" ] || [ -z "${!LOG_VAR}" ]; then
    break
  fi
  echo -e "    - name: ${!LOG_VAR}\n      topic: ${!TOPIC_VAR}" >> pushclient_default.conf
done

if [ -z "${PUSH_CLIENT_TVM_SECRET}" ]; then
  SECRET_FILE=$(echo "$BSCONFIG_IDIR/tvm_secret/client_secret" | sed -e 's/\//\\\//g')
  sed -i "s/%TVM_SECRET_FILE%/tvm-secret-file: $SECRET_FILE/g" pushclient_default.conf
  unset PUSH_CLIENT_TVM_SECRET
else
  sed -i "s/%TVM_SECRET_FILE%//g" pushclient_default.conf
fi

./push-client -c pushclient_default.conf -f
