#!/bin/bash
set -exo pipefail

export NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true -Dnetworkaddress.cache.ttl=10 -Dnetworkaddress.cache.negative.ttl=10"
export DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
export LIBRARY_PATH_ARGS="-Djava.library.path=."
export IN_PORTO_ARGS="-DPORTO=1"
export JAVA_ARGS="$NET_ARGS $DUMP_ARGS $LIBRARY_PATH_ARGS $IN_PORTO_ARGS"

if test -d /cores
then
    export CORE_DIR="/cores"
else
    export CORE_DIR="/coredumps"
fi

export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
export JAVA_LD_LIBRARY_PATH=$BSCONFIG_IDIR
export JAVA_LD_PRELOAD=${JAVA_LD_PRELOAD:+$JAVA_LD_PRELOAD:}$BSCONFIG_IDIR/libldpreload.so

export GENCFG_RELEASE=$(jq .leader.dynamicProperties.GENCFG_RELEASE metainstance.json|tr -d '"')
export REPLICA_NAME=$(jq .leader.dynamicProperties.GENCFG_GROUP metainstance.json|tr -d '"'|tr 'A-Z_' 'a-z-')

