#!/bin/bash
set -e

CONF_FILE="$(cd -- "$(dirname "$1")" &> /dev/null && pwd)/$(basename "$1")"
SCRIPT_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )
if [ ! -x "$SCRIPT_DIR/olelole_bin" ]; then
  cd "$SCRIPT_DIR"
  ../../../../ya package ./package.json --tar --raw-package-path=olelole_bin || (cd -; exit 1)
  cd -
fi

cd "$SCRIPT_DIR/olelole_bin"
source classpath.sh || (cd -; exit 1)
java -cp $CLASSPATH ru.yandex.olelole.AlertsUploader -c "$CONF_FILE" "${@:2}" || (cd -; exit 1)
cd ~-
