package ru.yandex.olelole;

import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.util.Locale;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.parser.uri.PctEncoder;
import ru.yandex.parser.uri.PctEncodingRule;

public class JugglerUrl implements JsonValue {
    String url;
    String title;
    JugglerUrlType type;

    public JugglerUrl(
        final String url,
        final String title,
        final JugglerUrlType type)
    {
        this.url = url;
        this.title = title;
        this.type = type;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("url");
        writer.value(url);
        writer.key("type");
        writer.value(type.toString().toLowerCase(Locale.ROOT));
        writer.key("title");
        writer.value(title);
        writer.endObject();
    }

    public static JugglerUrl alertUrl(final String alertName) {
        return new JugglerUrl(
            "https://yasm.yandex-team.ru/chart-alert/alerts=" + alertName +";",
            "Алерт в Головане",
            JugglerUrlType.YASM_ALERT);
    }

    public static JugglerUrl screenshotUrl(final String signal) {
        PctEncoder encoder = new PctEncoder(PctEncodingRule.QUERY);
        try {
            encoder.process(signal.toCharArray());
        } catch (CharacterCodingException ce) {
        }

        return new JugglerUrl(
            "https://s.yasm.yandex-team.ru/chart/signals" + encoder.toString(),
            "Снапшот графика алерта",
            JugglerUrlType.SCREENSHOT_URL);
    }

    public static JugglerUrl graphUrl(final String signal) {
        PctEncoder encoder = new PctEncoder(PctEncodingRule.QUERY);
        try {
            encoder.process(signal.toCharArray());
        } catch (CharacterCodingException ce) {
        }
        return new JugglerUrl(
            "https://yasm.yandex-team.ru/chart/signals" + encoder.toString(),
            "Алерт в Головане",
            JugglerUrlType.SCREENSHOT_URL);
    }

    public enum JugglerUrlType {
        YASM_ALERT,
        SCREENSHOT_URL,
        GRAPH_URL,
        YASM_TEMPLATE,
        NANNY,
        WIKI,
        URL;
    }
}
