package ru.yandex.olelole.config;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;

public abstract class AbstractAlertMetaConfigBuilder
    <T extends AbstractAlertMetaConfigBuilder<T>>
     implements AlertMetaConfig
{
    private Set<String> tags;
    private String itype;
    private String project;
    private String ctype;
    private String wiki;
    private Collection<String> nanny;
    private String yasmPanel;
    private String yasmTemplate;
    private String host;
    private String service;
    private String alertsConfigUri;

    AbstractAlertMetaConfigBuilder(final AlertMetaConfig config) {
        tags(config.tags());
        itype(config.itype());
        project(config.project());
        ctype(config.ctype());
        wiki(config.wiki());
        nanny(config.nanny());
        yasmPanel(config.yasmPanel());
        yasmTemplate(config.yasmTemplate());
        host(config.host());
        service(config.service());
        alertsConfigUri(config.alertsConfigUri());
    }

    AbstractAlertMetaConfigBuilder(
        final IniConfig config,
        final AlertMetaConfig defaults)
        throws ConfigException
    {
        this.tags =
            config.get(
                "tags",
                defaults.tags(),
                new CollectionParser<>(
                    String::trim,
                    LinkedHashSet::new));
        this.itype = config.getString("itype", defaults.itype());
        this.project = config.getString("project", defaults.project());
        this.ctype = config.getString("ctype", defaults.ctype());
        this.wiki = config.getString("wiki", defaults.wiki());
        this.nanny = config.get(
            "nanny",
            defaults.nanny(),
            new CollectionParser<>(NonEmptyValidator.TRIMMED, LinkedHashSet::new));
        this.yasmPanel = config.getString("yasm-panel", defaults.yasmPanel());
        this.yasmTemplate =
            config.getString("yasm-template", defaults.yasmTemplate());
        this.host = config.getString("host", defaults.host());
        this.service = config.getString("service", defaults.service());
        this.alertsConfigUri =
            config.getString("alerts-config-uri", defaults.alertsConfigUri());
    }

    @Override
    public Set<String> tags() {
        return tags;
    }

    public T tags(final Set<String> value) {
        this.tags = new LinkedHashSet<String>(
            value);
        return self();
    }

    @Override
    public String itype() {
        return itype;
    }

    public T itype(final String value) {
        this.itype = value;
        return self();
    }

    @Override
    public String project() {
        return project;
    }

    public T project(final String value) {
        this.project = value;
        return self();
    }

    @Override
    public String ctype() {
        return ctype;
    }

    public T ctype(final String value) {
        this.ctype = value;
        return self();
    }

    @Override
    public String wiki() {
        return wiki;
    }

    public T wiki(final String value) {
        this.wiki = value;
        return self();
    }

    @Override
    public Collection<String> nanny() {
        return nanny;
    }

    public T nanny(final Collection<String> value) {
        this.nanny = value;
        return self();
    }

    @Override
    public String yasmPanel() {
        return yasmPanel;
    }

    public T yasmPanel(final String value) {
        this.yasmPanel = value;
        return self();
    }

    @Override
    public String yasmTemplate() {
        return yasmTemplate;
    }

    public T yasmTemplate(final String value) {
        this.yasmTemplate = value;
        return self();
    }

    @Override
    public String host() {
        return host;
    }

    public T host(final String value) {
        this.host = value;
        return self();
    }

    @Override
    public String service() {
        return service;
    }

    public T service(final String value) {
        this.service = value;
        return self();
    }

    @Override
    public String alertsConfigUri() {
        return alertsConfigUri;
    }

    public T alertsConfigUri(final String value) {
        this.alertsConfigUri = value;
        return self();
    }

    protected abstract T self();
}
