package ru.yandex.olelole.config;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractAlertWindowConfigBuilder
    <T extends AbstractAlertWindowConfigBuilder<T>>
    implements AlertWindowConfig, ConfigBuilder<T>
{
    private String aggregation;
    private long duration;

    AbstractAlertWindowConfigBuilder(final AlertWindowConfig config) {
        aggregation(config.aggregation());
        duration(config.duration());
    }

    AbstractAlertWindowConfigBuilder(
        final IniConfig config,
        final AlertWindowConfig defaults)
        throws ConfigException
    {
        aggregation = AGGREGATION.extract(config, defaults.aggregation());
        duration = DURATION.extract(config, defaults.duration());
    }

    @Override()
    public String aggregation() {
        return aggregation;
    }

    public T aggregation(final String value) {
        this.aggregation = value;
        return self();
    }

    @Override()
    public long duration() {
        return duration;
    }

    public T duration(final long value) {
        this.duration = value;
        return self();
    }
}
