package ru.yandex.olelole.config;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractNotificationConfigBuilder
    <T extends AbstractNotificationConfigBuilder<T>>
    implements ConfigBuilder<T>, NotificationConfig
{
    private LocalTime timeStart;
    private LocalTime timeEnd;
    private Integer dayStart;
    private Integer dayEnd;
    private NotificationTimePreset preset;
    private List<String> logins;
    private NotificationType method;
    private Integer restartAfter;
    private String pronounce;
    private Integer repeat;
    private Integer onSuccessNextCallDelay;

    AbstractNotificationConfigBuilder(final NotificationConfig config) {
        timeStart(config.timeStart());
        timeEnd(config.timeEnd());
        dayStart(config.dayStart());
        dayEnd(config.dayEnd());
        preset(config.preset());
        logins(config.logins());
        method(config.method());
        restartAfter(config.restartAfter());
        pronounce(config.pronounce());
        repeat(config.repeat());
        onSuccessNextCallDelay(config.onSuccessNextCallDelay());
    }

    AbstractNotificationConfigBuilder(
        final IniConfig config,
        final NotificationConfig defaults)
        throws ConfigException
    {
        timeStart = TIME_START.extract(config, defaults.timeStart());
        timeEnd = TIME_END.extract(config, defaults.timeEnd());
        dayStart = DAY_START.extract(config, defaults.dayStart());
        dayEnd = DAY_END.extract(config, defaults.dayEnd());
        preset = PRESET.extract(config, defaults.preset());
        logins = LOGINS.extract(config, defaults.logins());
        method = METHOD.extract(config, defaults.method());
        restartAfter = RESTART_AFTER.extract(config, defaults.restartAfter());
        pronounce = PRONOUNCE.extract(config, defaults.pronounce());
        repeat = REPEAT.extract(config, defaults.repeat());
        onSuccessNextCallDelay =
            ON_SUCCESS_NEXT_CALL_DELAY.extract(
                config,
                defaults.onSuccessNextCallDelay());
    }

    @Override
    public LocalTime timeStart() {
        return timeStart;
    }

    public T timeStart(final LocalTime timeStart) {
        this.timeStart = timeStart;
        return self();
    }

    @Override
    public LocalTime timeEnd() {
        return timeEnd;
    }

    public T timeEnd(final LocalTime timeEnd) {
        this.timeEnd = timeEnd;
        return self();
    }

    @Override
    public Integer dayStart() {
        return dayStart;
    }

    public T dayStart(final Integer dayStart) {
        this.dayStart = dayStart;
        return self();
    }

    @Override
    public Integer dayEnd() {
        return dayEnd;
    }

    public T dayEnd(final Integer dayEnd) {
        this.dayEnd = dayEnd;
        return self();
    }

    @Override
    public NotificationTimePreset preset() {
        return preset;
    }

    public T preset(final NotificationTimePreset preset) {
        this.preset = preset;
        return self();
    }

    @Override
    public List<String> logins() {
        return logins;
    }

    public T logins(final List<String> logins) {
        this.logins = new ArrayList<>(logins);
        return self();
    }

    @Override
    public NotificationType method() {
        return method;
    }

    public T method(final NotificationType method) {
        this.method = method;
        return self();
    }

    @Override
    public Integer restartAfter() {
        return restartAfter;
    }

    public T restartAfter(final Integer restartAfter) {
        this.restartAfter = restartAfter;
        return self();
    }

    @Override
    public String pronounce() {
        return pronounce;
    }

    public T pronounce(final String pronounce) {
        this.pronounce = pronounce;
        return self();
    }

    @Override
    public Integer repeat() {
        return repeat;
    }

    public T repeat(final Integer repeat) {
        this.repeat = repeat;
        return self();
    }

    @Override
    public Integer onSuccessNextCallDelay() {
        return onSuccessNextCallDelay;
    }

    public T onSuccessNextCallDelay(final Integer onSuccessNextCallDelay) {
        this.onSuccessNextCallDelay = onSuccessNextCallDelay;
        return self();
    }
}
