package ru.yandex.olelole.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class AlertConfigBuilder
     extends AbstractAlertConfigBuilder<AlertConfigBuilder>
{
    public AlertConfigBuilder() {
        this(AlertConfigDefaults.INSTANCE);
    }

    public AlertConfigBuilder(final AlertConfig config) {
        super(config);
    }

    public AlertConfigBuilder(
        final IniConfig config,
        final String name)
        throws ConfigException
    {
        this(config, name, AlertConfigDefaults.INSTANCE, AlertMetaConfigDefaults.INSTANCE);
    }

    public AlertConfigBuilder(
        final IniConfig config,
        final String name,
        final AlertMetaConfig metaDefaults)
        throws ConfigException
    {
        super(config, name, AlertConfigDefaults.INSTANCE, metaDefaults);
    }

    public AlertConfigBuilder(
        final IniConfig config,
        final String name,
        final AlertConfig defaults,
        final AlertMetaConfig metaDefaults)
        throws ConfigException
    {
        super(config, name, defaults, metaDefaults);
    }

    public ImmutableAlertConfig build() throws ConfigException {
        return new ImmutableAlertConfig(
            this);
    }

    @Override
    protected AlertConfigBuilder self() {
        return this;
    }
}
