package ru.yandex.olelole.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class AlertMetaConfigBuilder
     extends AbstractAlertMetaConfigBuilder<AlertMetaConfigBuilder>
{
    public AlertMetaConfigBuilder() {
        this(AlertMetaConfigDefaults.INSTANCE);
    }

    public AlertMetaConfigBuilder(final AlertMetaConfig config) {
        super(config);
    }

    public AlertMetaConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, AlertMetaConfigDefaults.INSTANCE);
    }

    public AlertMetaConfigBuilder(
        final IniConfig config,
        final AlertMetaConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableAlertMetaConfig build() throws ConfigException {
        return new ImmutableAlertMetaConfig(
            this);
    }

    @Override
    protected AlertMetaConfigBuilder self() {
        return this;
    }
}
