package ru.yandex.olelole.config;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveValidator;

public interface AlertWindowConfig {
    ParameterConfig<String> AGGREGATION =
        new ParameterConfig<>(
            "aggregation",
            GenericFunction.identity(),
            NonEmptyValidator.INSTANCE);

    ParameterConfig<Long> DURATION =
        new ParameterConfig<>(
            "duration",
            Long::valueOf,
            PositiveValidator.instance());

    static void toIniConfig(
        final IniConfig ini,
        final AlertWindowConfig config)
    {
        ini.putAsString("aggregation", config.aggregation());
        ini.putAsString("duration", config.duration());
    }

    String aggregation();

    long duration();
}
