package ru.yandex.olelole.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class AlertWindowConfigBuilder
    extends AbstractAlertWindowConfigBuilder<AlertWindowConfigBuilder>
{
    public AlertWindowConfigBuilder() {
        this(AlertWindowConfigDefaults.INSTANCE);
    }

    public AlertWindowConfigBuilder(final AlertWindowConfig config) {
        super(config);
    }

    public AlertWindowConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, AlertWindowConfigDefaults.INSTANCE);
    }

    public AlertWindowConfigBuilder(
        final IniConfig config,
        final AlertWindowConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableAlertWindowConfig build() throws ConfigException {
        return new ImmutableAlertWindowConfig(
            this);
    }

    @Override
    public AlertWindowConfigBuilder self() {
        return this;
    }
}
