package ru.yandex.olelole.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class AlertsConfigBuilder
     extends AbstractAlertsConfigBuilder<AlertsConfigBuilder>
{
    public AlertsConfigBuilder() {
        this(AlertsConfigDefaults.INSTANCE);
    }

    public AlertsConfigBuilder(final AlertsConfig config) {
        super(config);
    }

    public AlertsConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, AlertsConfigDefaults.INSTANCE);
    }

    public AlertsConfigBuilder(
        final IniConfig config,
        final AlertsConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableAlertsConfig build() throws ConfigException {
        return new ImmutableAlertsConfig(
            this);
    }

    @Override
    protected AlertsConfigBuilder self() {
        return this;
    }
}
