package ru.yandex.olelole.config;

import java.text.ParseException;

import ru.yandex.function.GenericFunction;

public enum DoubleIntervalParser implements GenericFunction<String, DoubleInterval, Exception> {
    INSTANCE;

    @Override
    public DoubleInterval apply(final String s) throws Exception {
        String str = s.trim();
        int sep = str.indexOf('-');
        if (sep < 0) {
            throw new ParseException("Invalid format, expeting 10-20 but got " + s, sep);
        }

        Double left;
        Double right;
        String part = s.substring(0, sep);
        if (part.isEmpty()) {
            left = null;
        } else {
            left = Double.parseDouble(part);
        }

        if (sep < str.length() - 1) {
            part = s.substring(sep + 1);
            right = Double.parseDouble(part);
        } else {
            right = null;
        }

        return new DoubleInterval(left, right);
    }
}
