package ru.yandex.olelole.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;

public class ImmutableAlertConfig
    extends ImmutableAlertMetaConfig
     implements AlertConfig
{
    private final String name;
    private final String signal;
    private final String pronounce;
    private final DoubleInterval warn;
    private final DoubleInterval crit;
    private final Integer stableTime;
    private final Integer critTime;
    private final ImmutableAlertWindowConfig window;
    private final List<ImmutableNotificationConfig> notifications;
    private final Set<String> notificationLinks;

    public ImmutableAlertConfig(
        final AlertConfig config)
        throws ConfigException
    {
        super(config);
        this.name = config.name();
        this.signal = config.signal();
        this.warn = config.warn();
        this.crit = config.crit();
        this.stableTime = config.stableTime();
        this.critTime = config.critTime();
        this.pronounce = config.pronounce();
        AlertWindowConfig window = config.window();
        if (window == null) {
            this.window = null;
        } else {
            this.window = new ImmutableAlertWindowConfig(window);
        }

        List<ImmutableNotificationConfig> notifications = new ArrayList<>();
        for (NotificationConfig nconfig: config.notifications()) {
            notifications.add(new ImmutableNotificationConfig(nconfig));
        }

        this.notifications = Collections.unmodifiableList(notifications);
        this.notificationLinks = Collections.unmodifiableSet(new LinkedHashSet<>(config.notificationLinks()));
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public String signal() {
        return signal;
    }

    @Override
    public ImmutableAlertWindowConfig window() {
        return window;
    }

    @Override
    public List<ImmutableNotificationConfig> notifications() {
        return notifications;
    }

    @Override
    public Set<String> notificationLinks() {
        return notificationLinks;
    }

    @Override
    public DoubleInterval warn() {
        return warn;
    }

    @Override
    public DoubleInterval crit() {
        return crit;
    }

    @Override
    public Integer stableTime() {
        return stableTime;
    }

    @Override
    public Integer critTime() {
        return critTime;
    }

    @Override
    public String pronounce() {
        return pronounce;
    }
}
