package ru.yandex.olelole.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;

public class ImmutableAlertMetaConfig
     implements AlertMetaConfig
{
    private final Set<String> tags;
    private final String itype;
    private final String project;
    private final String ctype;
    private final String wiki;
    private final Collection<String> nanny;
    private final String yasmPanel;
    private final String yasmTemplate;
    private final String host;
    private final String service;
    private final String alertsConfigUri;

    public ImmutableAlertMetaConfig(
        final AlertMetaConfig config)
        throws ConfigException
    {
        this.tags = Collections.unmodifiableSet(config.tags());
        this.itype = config.itype();
        this.project = config.project();
        this.ctype = config.ctype();
        this.wiki = config.wiki();
        this.nanny = config.nanny();
        this.yasmPanel = config.yasmPanel();
        this.yasmTemplate = config.yasmTemplate();
        this.host = config.host();
        this.service = config.service();
        this.alertsConfigUri = config.alertsConfigUri();
    }

    @Override
    public Set<String> tags() {
        return tags;
    }

    @Override
    public String itype() {
        return itype;
    }

    @Override
    public String project() {
        return project;
    }

    @Override
    public String ctype() {
        return ctype;
    }

    @Override
    public String wiki() {
        return wiki;
    }

    @Override
    public Collection<String> nanny() {
        return nanny;
    }

    @Override
    public String yasmPanel() {
        return yasmPanel;
    }

    @Override
    public String yasmTemplate() {
        return yasmTemplate;
    }

    @Override
    public String host() {
        return host;
    }

    @Override
    public String service() {
        return service;
    }

    @Override
    public String alertsConfigUri() {
        return alertsConfigUri;
    }
}
