package ru.yandex.olelole.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableAlertWindowConfig
    implements AlertWindowConfig, ImmutableConfig
{
    private final String aggregation;
    private final long duration;

    public ImmutableAlertWindowConfig(
        final AlertWindowConfig config)
        throws ConfigException
    {
        aggregation = AGGREGATION.validate(config.aggregation());
        duration = DURATION.validate(config.duration());
    }

    @Override
    public String aggregation() {
        return aggregation;
    }

    @Override
    public long duration() {
        return duration;
    }
}
