package ru.yandex.olelole.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;

public class ImmutableAlertsConfig
    extends ImmutableAlertMetaConfig
    implements AlertsConfig
{
    private final String module;
    private final String namespace;
    private final String abc;
    private final Map<String, ImmutableNotificationConfig> notifications;
    private final Set<ImmutableAlertConfig> alerts;

    public ImmutableAlertsConfig(
        final AlertsConfig config)
        throws ConfigException
    {
        super(config);
        this.module = config.module();
        this.namespace = config.namespace();
        this.abc = config.abc();
        Map<String, ImmutableNotificationConfig> notifications = new LinkedHashMap<>();
        for (Map.Entry<String, ? extends NotificationConfig> entry: config.notifyPresets().entrySet()) {
            notifications.put(entry.getKey(), new ImmutableNotificationConfig(entry.getValue()));
        }
        this.notifications = Collections.unmodifiableMap(notifications);
        Set<ImmutableAlertConfig> alerts = new LinkedHashSet<>();
        for (AlertConfig alertConfig: config.alerts()) {
            ImmutableAlertConfig immutableAlertConfig = new ImmutableAlertConfig(alertConfig);
            if (!this.notifications.keySet().containsAll(immutableAlertConfig.notificationLinks())) {
                throw new ConfigException(
                    "Missing notification preset, existing presets: "
                        + String.join(",",this.notifications.keySet())
                        + " but in alert " + immutableAlertConfig.name()
                        + " got references: "
                        + String.join(",", immutableAlertConfig.notificationLinks()));
            }
            alerts.add(immutableAlertConfig);
        }
        this.alerts = Collections.unmodifiableSet(alerts);
    }

    @Override
    public String module() {
        return module;
    }

    @Override
    public String namespace() {
        return namespace;
    }

    @Override
    public String abc() {
        return abc;
    }

    @Override
    public Map<String, ImmutableNotificationConfig> notifyPresets() {
        return notifications;
    }

    @Override
    public Set<ImmutableAlertConfig> alerts() {
        return alerts;
    }
}
