package ru.yandex.olelole.config;

import java.time.LocalTime;
import java.util.List;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableNotificationConfig
    implements ImmutableConfig, NotificationConfig
{
    private final LocalTime timeStart;
    private final LocalTime timeEnd;
    private final Integer dayStart;
    private final Integer dayEnd;
    private final NotificationTimePreset preset;
    private final List<String> logins;
    private final NotificationType method;
    private final Integer restartAfter;
    private final String pronounce;
    private final Integer repeat;
    private final Integer onSuccessNextCallDelay;

    public ImmutableNotificationConfig(
        final NotificationConfig config)
        throws ConfigException
    {
        timeStart = TIME_START.validate(config.timeStart());
        timeEnd = TIME_END.validate(config.timeEnd());
        dayStart = DAY_START.validate(config.dayStart());
        dayEnd = DAY_END.validate(config.dayEnd());
        preset = PRESET.validate(config.preset());
        logins = LOGINS.validate(config.logins());
        method = METHOD.validate(config.method());
        restartAfter = RESTART_AFTER.validate(config.restartAfter());
        pronounce = PRONOUNCE.validate(config.pronounce());
        repeat = REPEAT.validate(config.repeat());
        onSuccessNextCallDelay =
            ON_SUCCESS_NEXT_CALL_DELAY.validate(
                config.onSuccessNextCallDelay());
    }

    @Override
    public LocalTime timeStart() {
        return timeStart;
    }

    @Override
    public LocalTime timeEnd() {
        return timeEnd;
    }

    @Override
    public Integer dayStart() {
        return dayStart;
    }

    @Override
    public Integer dayEnd() {
        return dayEnd;
    }

    @Override
    public NotificationTimePreset preset() {
        return preset;
    }

    @Override
    public List<String> logins() {
        return logins;
    }

    @Override
    public NotificationType method() {
        return method;
    }

    @Override
    public Integer restartAfter() {
        return restartAfter;
    }

    @Override
    public String pronounce() {
        return pronounce;
    }

    @Override
    public Integer repeat() {
        return repeat;
    }

    @Override
    public Integer onSuccessNextCallDelay() {
        return onSuccessNextCallDelay;
    }
}
