package ru.yandex.olelole.config;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.CollectionValidator;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.string.NonEmptyCollectionValidator;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveValidator;

public interface NotificationConfig {
    ParameterConfig<LocalTime> TIME_START =
        new ParameterConfig<>(
            "time-start",
            LocalTime::parse,
            GenericFunction.identity(),
            true);

    ParameterConfig<LocalTime> TIME_END =
        new ParameterConfig<>(
            "time-end",
            LocalTime::parse,
            GenericFunction.identity(),
            true);

    ParameterConfig<Integer> DAY_START =
        new ParameterConfig<>(
            "day-start",
            Integer::valueOf,
            new NullToDefaultFunction<>(PositiveValidator.instance()),
            true);

    ParameterConfig<Integer> DAY_END =
        new ParameterConfig<>(
            "day-end",
            Integer::valueOf,
            new NullToDefaultFunction<>(PositiveValidator.instance()),
            true);

    ParameterConfig<NotificationTimePreset> PRESET =
        new ParameterConfig<>(
            "preset",
            new EnumParser<>(NotificationTimePreset.class),
            GenericFunction.identity(),
            true);

    ParameterConfig<List<String>> LOGINS =
        new ParameterConfig<>(
            "logins",
            new CollectionParser<>(NonEmptyValidator.TRIMMED, ArrayList::new),
            new CollectionValidator<String, List<String>>(
                NonEmptyValidator.TRIMMED)
                .andThen(NonEmptyCollectionValidator.instance())
                .andThen(ArrayList::new));

    ParameterConfig<NotificationType> METHOD =
        new ParameterConfig<>(
            "method",
            new EnumParser<>(NotificationType.class),
            GenericFunction.identity());

    ParameterConfig<Integer> RESTART_AFTER =
        new ParameterConfig<>(
            "restart-after",
            Integer::valueOf,
            new NullToDefaultFunction<>(PositiveValidator.instance()),
            true);

    ParameterConfig<String> PRONOUNCE =
        new ParameterConfig<>(
            "pronounce",
            GenericFunction.identity(),
            new NullToDefaultFunction<>(NonEmptyValidator.TRIMMED),
            true);

    ParameterConfig<Integer> REPEAT =
        new ParameterConfig<>(
            "repeat",
            Integer::valueOf,
            new NullToDefaultFunction<>(PositiveValidator.instance()),
            true);

    ParameterConfig<Integer> ON_SUCCESS_NEXT_CALL_DELAY =
        new ParameterConfig<>(
            "on-success-next-call-delay",
            Integer::valueOf,
            new NullToDefaultFunction<>(PositiveValidator.instance()),
            true);

    static void toIniConfig(
        final IniConfig ini,
        final NotificationConfig config)
    {
        ini.putAsString("time-start", config.timeStart());
        ini.putAsString("time-end", config.timeEnd());
        ini.putAsString("day-start", config.dayStart());
        ini.putAsString("day-end", config.dayEnd());
        ini.putEnum("preset", config.preset());
        ini.putAsString("logins", config.logins());
        ini.putEnum("method", config.method());
        ini.putAsString("restart-after", config.restartAfter());
        ini.putAsString("pronounce", config.pronounce());
        ini.putAsString("repeat", config.repeat());
        ini.putAsString(
            "on-success-next-call-delay",
            config.onSuccessNextCallDelay());
    }

    LocalTime timeStart();

    LocalTime timeEnd();

    Integer dayStart();

    Integer dayEnd();

    NotificationTimePreset preset();

    List<String> logins();

    NotificationType method();

    Integer restartAfter();

    String pronounce();

    Integer repeat();

    Integer onSuccessNextCallDelay();
}
