package ru.yandex.olelole.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class NotificationConfigBuilder
     extends AbstractNotificationConfigBuilder<NotificationConfigBuilder>
{
    public NotificationConfigBuilder() {
        this(NotificationConfigDefaults.INSTANCE);
    }

    public NotificationConfigBuilder(final NotificationConfig config) {
        super(config);
    }

    public NotificationConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, NotificationConfigDefaults.INSTANCE);
    }

    public NotificationConfigBuilder(
        final IniConfig config,
        final NotificationConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableNotificationConfig build() throws ConfigException {
        return new ImmutableNotificationConfig(
            this);
    }

    @Override
    public NotificationConfigBuilder self() {
        return this;
    }
}
