#!/usr/bin/python
# -*- coding: UTF-8 -*-

import argparse
from mail.tools.common.postfix import get_queue, remove_messages, is_from_deferred, has_single_rcpt

TOXIC = {
    ("MAILER-DAEMON", "no-reply@support-uber.com"),
    ("realty-news@yandex-team.ru", "ra89527755420@yandex.ru"),
    ("robot@kinopoisk.ru", "KP_tech@kinopoisk.ru"),
    ("yb@balance-mail.yandex.ru", "errors@balance.yandex.ru")
}


def is_toxic_sender_and_rcpt(item):
    sender = item["sender"]
    rcpt = item["recipients"][0]["address"]
    return (sender, rcpt) in TOXIC


def is_reason_rate_limit(item):
    return "has exceeded their message rate limit" in item["recipients"][0]["delay_reason"]


def find_trash_messages(queue_data):
    trash = []
    for item in queue_data:
        if not (is_from_deferred(item) and has_single_rcpt(item)):
            continue

        if is_toxic_sender_and_rcpt(item) and is_reason_rate_limit(item):
            trash.append(item)
            continue

    return trash


def main(dry_run):
    items = get_queue("deferred")
    messages = find_trash_messages(items)
    if dry_run:
        for item in messages:
            print item["queue_id"], item["sender"], item["recipients"][0]
        return

    remove_messages([m["queue_id"] for m in messages])
    print "Removed total:", len(messages)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Clean postfix queue from toxic messages")
    parser.add_argument("--dryrun", action='store_true', help="Just prints items to remove, nothing is removed")
    args = parser.parse_args()

    main(args.dryrun)
