import requests

PGPASS_FILE = '/app/secrets/pgpass'


def get_conninfo(sharpei_host, dbuser, uid, mode='master'):
    resp = requests.get(_make_url(sharpei_host, uid, mode))
    if resp.status_code != 200:
        raise RuntimeError('Sharpei responds %d' % resp.status_code)
    resp_json = resp.json()
    return _make_dsn(resp_json['addrs'][0], dbuser)


def _make_url(sharpei_host, uid, mode):
    return '{url}/conninfo?uid={uid}&mode={mode}'.format(url=sharpei_host, uid=uid, mode=mode)


def _get_passwd(user):
    for line in open(PGPASS_FILE, 'rt'):
        _, usr, pwd = line.strip().rsplit(':', 2)
        if usr == user:
            return pwd
    raise RuntimeError('Unable to find pwd for "{user}" in pgpass'.format(user=user))


def _make_dsn(addr, user='mxback'):
    pwd = _get_passwd(user)
    return 'host={host} port={port} dbname={dbname} user={user} password={pwd}'.format(user=user, pwd=pwd, **addr)
