import subprocess
import json
import yaml

from library.python.vault_client.instances import Production as VaultClient
from library.python.vault_client.errors import ClientError


def get_sharpei_response(sharpei_host, sharpei_access_machine):
    cmd = [
        "ssh",
        sharpei_access_machine,
        f"curl '{sharpei_host}/v3/stat'"
    ]
    p = subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    (response, _) = p.communicate()
    return response


def shard_priority(shard_name):
    if 'xdb' in shard_name:
        # Hot shard is xdbNN - first priority
        # Warm shard is xdbNNN
        # Cold shard is xdbNNNN - last priority
        return len(shard_name)
    # MDB shard - very first to run
    return 0


def get_master_dns(sharpei_response, user, password):
    shards = json.loads(sharpei_response)
    for _, shard in sorted(shards.items(), key=lambda shard_item: shard_priority(shard_item[1]['name'])):
        # if shard['name'].startswith('xdb') and len(shard['name']) == 7:
        #     print(f'Skipping cold shard {shard["name"]}')
        #     continue
        for database in shard["databases"]:
            if database["role"] == "master":
                db = database["address"]
                url = f"postgresql://{user}:{password}@{db['host']}:{db['port']}/{db['dbname']}"
                yield shard['name'], url


def get_password_from_yav(user, sharpei_host):
    secret_id = 'sec-01d5v5dv67pza174zneyt5s1tf'

    name = {
        'sharpei-production.mail.yandex.net': 'users.yaml',
        'sharpei-testing.mail.yandex.net': 'users_test.yaml',
        'sharpei-intranet-production.mail.yandex.net': 'users_corp.yaml'
    }[sharpei_host]

    client = VaultClient(decode_files=True)

    try:
        secret = client.get_version(secret_id)
    except ClientError as e:
        raise

    if name in secret['value']:
        secret_yaml = yaml.safe_load(secret['value'][name])
        try:
            password = secret_yaml[user]['password']
        except KeyError:
            raise Exception('Password for user {} not found in secret'.format(user))
    else:
        raise Exception('Environment {} not found in secret'.format(name))

    return password
