from itertools import chain


def subepics(client, epics):
    """Find all issues related to epics"""
    links = list(chain.from_iterable(
        epic.links.get_all() for epic in epics
    ))
    issues = [
        link.object for link in links
        if link.direction == 'inward'
        and link.type.id == client.linktypes['epic'].id
    ]
    return issues


def depends_on(client, link):
    return is_blocking_relation(client, link, direction='outward')


def is_blocker_for(client, link):
    return is_blocking_relation(client, link, direction='inward')


def is_blocking_relation(client, link, direction='outward'):
    return (
        link.direction == direction
        and link.type.id == client.linktypes['depends'].id
    )
