import logging

from argparse import ArgumentParser, RawTextHelpFormatter

from mail.tools.yamail_info.bin.ya_db.configs import DATABASES, EnvironmentTypes, get_configs_description
from mail.tools.yamail_info.bin.ya_db.db import Database
from mail.tools.yamail_info.lib.utils import common_arguments, init_logging

log = logging.getLogger(__name__)


def main():
    parser = ArgumentParser(parents=[common_arguments()],
                            conflict_handler='resolve',
                            formatter_class=RawTextHelpFormatter,
                            epilog=f'Existing configurations:\n{get_configs_description(indent=2)}')
    parser.add_argument(
        '--db-name',
        dest='db',
        help='database name',
        choices=DATABASES.keys(),
        required=True,
    )
    parser.add_argument(
        '-m', '--mode',
        dest='mode',
        choices=['ro', 'rw'],
        help="database connection mode",
        default='ro'
    )
    parser.add_argument(
        '-e', '--env',
        choices=[e.value for e in EnvironmentTypes],
        help='environment',
        default=EnvironmentTypes.PROD,
    )
    args = parser.parse_args()

    init_logging(args.verbosity)

    db = Database(EnvironmentTypes(args.env), args.db, args.db_user)
    db.connect(args.mode)


if __name__ == '__main__':
    main()
