# coding: utf-8

from __future__ import print_function
import os
from argparse import ArgumentParser
import logging

from mail.tools.yamail_info.lib.config import (
    get_config_location,
    load_config,
    write_default_config
)
from mail.tools.yamail_info.lib.utils import init_logging, common_arguments
from mail.tools.yamail_info.lib.environment import make_env
from mail.tools.yamail_info.lib import sharpei


log = logging.getLogger(__name__)


def main():
    parser = ArgumentParser(parents=[common_arguments()])

    group = parser.add_mutually_exclusive_group(required=True)
    group.add_argument(
        '--shard_name',
        dest='shard_name',
        help='shard name',
    )
    group.add_argument(
        '--shard_id',
        dest='shard_id',
        help='shard id',
    )
    group.add_argument(
        '--cluster_id',
        dest='cluster_id',
        help='cluster id',
    )

    args = parser.parse_args()

    init_logging(args.verbosity)

    if not os.path.exists(get_config_location()):
        write_default_config(get_config_location())
        return 1
    env = make_env(args.env, args.db_user, args.arcadia_root, load_config(get_config_location()))

    shard_id = ''
    if args.cluster_id:
        shard_id = env.get_shard_id_from_shiva(args.cluster_id)

    stats_json = env.get_url(sharpei.stats_url(env.SHARPEI))
    for shard in sharpei.parse_stats(stats_json):
        if shard.name == args.shard_name or shard.id == args.shard_id or shard.id == shard_id:
            env.run_psql(shard.master.address)
            break
    else:
        log.warning('Shard not found in sharpei')

if __name__ == '__main__':
    main()
