# coding: utf-8

import logging
import urllib
import json


log = logging.getLogger(__name__)


def make_bb_url(env, by_field, by_value, sid):
    args = {
        'attributes': '13',
        'aliases': 'getsocial',
        'emails': 'getall',
        'userip': '127.0.0.1',
        'format': 'json',
        'method': 'userinfo',
        'sid': sid,
        by_field: by_value
    }

    return env.BLACKBOX + '?' + urllib.parse.urlencode(args)


def parse_bb_resonse(bb_response):
    try:
        return json.loads(bb_response)
    except SyntaxError as exc:
        log.error(
            'Broken blackbox response: %s %s',
            exc, bb_response)


class NotAMailUser(Exception):
    pass


def find_uid_in_bb(bb_tree):
    try:
        return int(bb_tree['users'][0]['uid']['value'])
    except (KeyError, ValueError, TypeError) as exc:
        raise NotAMailUser(
            "Can't find uid in BlackBox response: %s" % exc
        )
