# coding: utf-8

from contextlib import closing
import os
import sys
from configparser import ConfigParser


DEFAULT_CONFIG = '''
[prod]
psql_user = developer
# host where you have psql and access
# to production databases
# add password for psql_user to ~/.pgpass
psql_host = web.yandex.ru
web_host = web.yandex.ru
[testing]
# passwords you can generate with
# https://github.yandex-team.ru/mail/wmidevenv/blob/master/wmidevenv/pgpass.py
psql_user = transfer
'''.strip()


def get_config_location():
    return os.path.expanduser('~/.ya-user.cfg')


def load_config(config_path):
    config = ConfigParser()
    config.read(config_path)
    return config


def write_default_config(config_path):
    print(
        'Generate new config file: %r' % config_path,
        file=sys.stderr
    )
    with closing(open(config_path, 'w')) as fd:
        fd.write(DEFAULT_CONFIG)
