from dataclasses import dataclass
from typing import Optional, Dict, Any


@dataclass
class CsvParserException(Exception):
    message: str
    params: Optional[Dict[str, Any]] = None


class EncodingDetectError(CsvParserException):
    def __init__(self, encoding: str, confidence: float) -> None:
        super(EncodingDetectError, self).__init__(
            message="csv_encoding_detect_error",
            params={"encoding": encoding, "confidence": confidence},
        )


class BadCsvFile(CsvParserException):
    def __init__(self) -> None:
        super(BadCsvFile, self).__init__(message="csv_bad_file")


class BadHeaderRowError(CsvParserException):
    def __init__(self) -> None:
        super(BadHeaderRowError, self).__init__(message="csv_bad_header_row")


class NonUniqueColumnsError(BadHeaderRowError):
    pass


class UnknownColumnsError(BadHeaderRowError):
    pass


class MissingColumnsError(BadHeaderRowError):
    pass


class UnexpectedRowValueError(BadCsvFile):
    pass


class EmptyRowValueError(BadCsvFile):
    pass
