from dataclasses import dataclass
from enum import Enum
from typing import Optional


class UserMigrationStatus(Enum):
    LISTING = "listing"
    SYNCING = "syncing"
    CANCELING = "canceling"
    ERROR = "error"
    SUCCESS = "success"


class TaskType:
    LIST = "list_task"
    SYNC = "sync_task"


class OrgMigrationStatus(Enum):
    NOT_STARTED = "not_started"
    IN_PROGRESS = "in_progress"
    CANCELING = "canceling"
    ERROR = "error"
    SUCCESS = "success"


@dataclass
class UserStatistics:
    quota: Optional[int] = None
    files_size: Optional[int] = None
    files_count: Optional[int] = None


@dataclass
class UserMigration:
    org_id: str
    domain: str
    login: str
    status: UserMigrationStatus
    list_task_id: int
    sync_task_ids: list
    stats: UserStatistics
    error_reason: str = ""


@dataclass
class UserMigrationInfo:
    login: str
    status: UserMigrationStatus
    error_reason: str = ""


@dataclass
class UserMigrationExportInfo:
    login: str
    status: UserMigrationStatus
    stats: UserStatistics
    error_reason: str = ""


@dataclass
class MigrationStats:
    preparing: int = 0
    not_enough_quota: int = 0
    user_not_found: int = 0
    in_progress: int = 0
    success: int = 0
    error: int = 0
    canceling: int = 0
