from dataclasses import dataclass
from enum import Enum
from typing import Dict, Any, Optional


class ExternalProviderImapServer(Enum):
    GOOGLE = "imap.gmail.com"
    MICROSOFT = "outlook.office365.com"


class UserMigrationStatus(Enum):
    PREPARING = "preparing"
    INITIAL_SYNC = "initial_sync"
    SYNC_NEWEST = "sync_newest"
    ERROR = "error"
    STOPPING = "stopping"
    STOPPED = "stopped"


class TaskType:
    PREPARE = "prepare_task"
    STOP = "stop_task"


class OrgMigrationStatus(Enum):
    NOT_STARTED = "not_started"
    IN_PROGRESS = "in_progress"
    STOPPING = "stopping"
    SUCCESS = "success"
    ERROR = "error"


@dataclass
class MessagesCollectionStats:
    "Statistics of collecting messages from some source (e.g. a mailbox or a folder)."
    source_count: int = 0
    collected_count: int = 0
    failed_count: int = 0


@dataclass
class UserMigration:
    org_id: str
    domain: str
    login: str
    status: UserMigrationStatus
    prepare_task_id: int
    stop_task_id: int
    stats: Dict[str, Any]
    error_reason: str = ""


@dataclass
class UserMigrationExportInfo:
    login: str
    status: UserMigrationStatus
    error_reason: str
    mailbox_messages_collection_stats: Optional[MessagesCollectionStats]


@dataclass
class UserMigrationInfo:
    login: str
    status: UserMigrationStatus
    error_reason: str


@dataclass
class UserInfo:
    login: str
    uid: Optional[str] = None
    external_password: Optional[str] = None
    yandex_password: Optional[str] = None
    first_name: Optional[str] = None
    last_name: Optional[str] = None
    middle_name: Optional[str] = None
    gender: Optional[str] = None
    birthday: Optional[str] = None
    language: Optional[str] = None


@dataclass
class MailServerConnectionInfo:
    host: str
    port: int
    ssl: bool


@dataclass
class MailServerInfo:
    provider: str
    conn_info: Optional[MailServerConnectionInfo] = None


@dataclass
class MigrationStats:
    preparing: int = 0
    initial_sync: int = 0
    sync_newest: int = 0
    stopping: int = 0
    error: int = 0
    success: int = 0
