from dataclasses import dataclass
import datetime
from enum import Enum


class ExternalProvider(Enum):
    GOOGLE = "google"
    MICROSOFT = "microsoft"


class TaskWorkerStatus(Enum):
    PENDING = "pending"
    ERROR = "error"
    SUCCESS = "success"


@dataclass
class Task:
    task_id: int
    org_id: str
    domain: str

    created_ts: datetime.datetime
    type: str
    input: dict
    canceled: bool

    worker_id: str
    worker_status: TaskWorkerStatus
    worker_ts: datetime.datetime
    worker_output: dict


@dataclass
class ExternalSecretStatus:
    provider: str
    external_secret_loaded: bool = True
