import requests
import json
import os


BLACKBOX_SECRET_FILE = "/app/data/.blackbox.token"
DIRECTORY_SECRET_FILE = "/app/data/.directory.token"
TRACTOR_DB_VERSIONED_KEYS_FILE = "/app/data/.tractor_versioned_keys"
COLLECTORS_SECRET_FILE = "/app/data/.collectors_secret.token"
GOOGLE_SERVICE_ACCOUNT_FILE = "/app/data/.google_secret.json"
DISK_SECRET_FILE = "/app/data/.disk.token"
MS_SECRET_FILE = "/app/data/.ms_secret.json"
MDS_SECRET_FILE = "/app/data/.mds_secret.token"


class Secrets:
    def _generate_service_ticket(self, base_url, src, dst):
        url = f"{base_url}/tvm/tickets?src={src}&dsts={dst}"
        headers = {"Authorization": os.environ["TVMTOOL_LOCAL_AUTHTOKEN"]}
        resp = requests.get(url, headers=headers)
        resp.raise_for_status()
        return resp.json()[dst]["ticket"]

    def blackbox_secret(self):
        if os.path.exists(BLACKBOX_SECRET_FILE):
            return open(BLACKBOX_SECRET_FILE).read().strip()

        base_url = str(os.environ["DEPLOY_TVM_TOOL_URL"])
        return self._generate_service_ticket(base_url, "tractor", "blackbox")

    def collectors_secret(self):
        if os.path.exists(COLLECTORS_SECRET_FILE):
            return open(COLLECTORS_SECRET_FILE).read().strip()

        base_url = str(os.environ["DEPLOY_TVM_TOOL_URL"])
        return self._generate_service_ticket(base_url, "tractor", "collectors")

    def directory_secret(self):
        if os.path.exists(DIRECTORY_SECRET_FILE):
            return open(DIRECTORY_SECRET_FILE).read().strip()

        base_url = str(os.environ["DEPLOY_TVM_TOOL_URL"])
        return self._generate_service_ticket(base_url, "tractor", "directory")

    def google_secret(self):
        return json.loads(open(GOOGLE_SERVICE_ACCOUNT_FILE).read().strip())

    def yandex_disk_secret(self):
        if os.path.exists(DISK_SECRET_FILE):
            return open(DISK_SECRET_FILE).read().strip()

        base_url = str(os.environ["DEPLOY_TVM_TOOL_URL"])
        return self._generate_service_ticket(base_url, "tractor_disk", "disk")

    def mds_secret(self):
        if os.path.exists(MDS_SECRET_FILE):
            return open(MDS_SECRET_FILE).read().strip()

        base_url = str(os.environ["DEPLOY_TVM_TOOL_URL"])
        return self._generate_service_ticket(base_url, "ipa", "mds")

    def ms_secret(self):
        return json.loads(open(MS_SECRET_FILE).read().strip())

    def tractor_db_versioned_keys(self):
        return json.loads(open(TRACTOR_DB_VERSIONED_KEYS_FILE).read().strip())
