import traceback


def exception_info(e):
    stack_summary = traceback.extract_tb(e.__traceback__)
    last_frame = stack_summary[-1]
    last_frame = str(f"{last_frame.filename}:{last_frame.lineno} in {last_frame.name}")
    return {"reason": str(e), "last_frame": last_frame}


def extract_login(email: str) -> str:
    return email.split("@")[0]
