from itertools import chain
import time
import requests

from tractor.exception import TemporaryError


def need_retry(status_code: int) -> bool:
    return status_code // 100 == 5


def retry(base_delay: float, retries: int):
    def wrap(method):
        def _retry(*args, **kwargs):
            last_exception = None
            for delay in chain((0,), (base_delay * (1 << i) for i in range(retries))):
                if delay > 0:
                    time.sleep(delay)
                try:
                    return method(*args, **kwargs)
                except requests.HTTPError as ex:
                    if not need_retry(ex.response.status_code):
                        raise
                    last_exception = ex
                except TemporaryError as ex:
                    last_exception = ex
            raise last_exception

        return _retry

    return wrap
