import json
from tractor.crypto.versioned import VersionedKeyStorage
from tractor.settings import Settings


def load(settings: Settings):
    data = settings.get_or_default("versioned_keys/data", None)
    if data is None:
        file_path = settings.get("versioned_keys/path")
        with open(file_path, "r") as file:
            data = json.load(file)
    return VersionedKeyStorage(data)
