#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"
LOGFILE="/app/log/access.log"
ts=$(date +%s)

timetail -n 60 -r '^tskv	tskv_format=tractor-api-access-log	timestamp=.{11}(\d\d:\d\d:\d\d)' $LOGFILE | head -n -1 | \
awk -F $'\t' -v ts="$ts" -v prefix="http." '
        @include "/usr/share/yandex-mail-common/metrics-util.awk"

    {
        code = get_tskv_value($0, "status_code")
        tm = get_tskv_value($0, "duration")
        bytes_out = get_tskv_value($0, "bytes_out")
        method = get_tskv_value($0, "method")
        method = tolower(method)
        request = get_tskv_value($0, "request")
        path_end = index(request, "?") - 1
        if (path_end == -1) {
            path_end = length(request)
        }
        request = substr(request, 2, path_end - 1)
        gsub("[/]","_",request)
        gsub("^_*", "", request)
        orgid = ""
        if (match(request, "^organizations_([0-9]+)_", match_res)) {
            orgid = match_res[1]
            gsub("_[0-9]+_","_",request)
        }

        if (length(code) > 0 &&
            length(request) > 0 &&
            length(tm) > 0) # filter malformed entries
        {
            http["total"]++
            http["codes.total."code".tier_"orgid]++
            http["codes."method"."request"."code".tier_"orgid]++
        }
        if (code ~ /2../) {
            collect_timings(tm, "total.tier_"orgid, http_tm)
            collect_timings(tm, method"."request".tier_"orgid, http_tm)

            collect_timings(bytes_out, method"."request".tier_"orgid, http_bytes)
        }
    }
    END {
        for (metric in http) {
            print prefix metric, http[metric], ts
        }
        for (entry in http_tm) {
            print prefix "timings." entry, "[" http_tm[entry] "]", ts
        }
        for (entry in http_bytes) {
            print prefix "bytes_out." entry, "[" http_bytes[entry] "]", ts
        }
    }
' | awk '
    match($1,/tier_/) {
        tier = substr($1, RSTART+RLENGTH)
        if (tier == "") tier = "none"
        print substr($1,1,RSTART-2), $2, $3, tier
    }
    !/tier_/ {
        print
    }
'
