from flask import Flask, request, Response
from tractor_api.app.access_log import add_fields_to_log
from tractor_api.app.error_handling import (
    AppException,
    handle_app_exception,
    handle_http_error,
    handle_unhandled_exception,
)
from uuid import uuid4
from werkzeug.exceptions import HTTPException, InternalServerError

app = Flask(__name__, static_folder=None)


@app.before_request
def _setup_context_data() -> None:
    add_fields_to_log(x_request_id=request.headers.get("x-request-id") or str(uuid4()))


@app.errorhandler(HTTPException)
def _handle_http_error(e: HTTPException) -> Response:
    return handle_http_error(e)


@app.errorhandler(AppException)
def _handle_app_exception(e: AppException) -> Response:
    return handle_app_exception(e)


@app.errorhandler(InternalServerError)
def _handle_unhandled_exception(e: InternalServerError) -> Response:
    return handle_unhandled_exception(e)
