from tractor_api.app.uwsgi import uwsgi_module
from typing import Any


def add_fields_to_log(**kwargs: Any) -> None:
    uwsgi = uwsgi_module()
    for key, val in kwargs.items():
        uwsgi.set_logvar(key, prepare_value(val))


def prepare_value(value: Any) -> str:
    return str(value).replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t")
