from flask import Response, make_response
from typing import Any, Dict


def make_success_response(data: Any = {}, code: int = 200, headers=None) -> Response:
    if headers is None:
        return make_response(data, code)
    else:
        return make_response(data, code, headers)


def make_error_response(status_code: int, error_code: str, detail: Dict = {}) -> Response:
    return make_response({"error_code": error_code, "detail": detail}, status_code)
