from flask import Response
from typing import Dict
from tractor.disk.db import Database
from tractor_api.settings import settings
from tractor_api.app import app
from tractor_api.app.responses import make_success_response
from tractor_api.app.tvm import user_tvm, allowed_service


@user_tvm.route("/organizations/<org_id>/migration/cancel", methods=["POST"])
@user_tvm.route("/organizations/<org_id>/migration/disk/cancel", methods=["POST"])
@allowed_service("sarah")
def cancel_migration(org_id: str) -> Response:
    # todo parse csv logins and add to the sql query
    _cancel_migration(org_id, _make_env())
    return make_success_response()


def _cancel_migration(org_id: str, env: Dict):
    db: Database = env["db"]
    with db.make_connection() as conn:
        with conn.cursor() as cur:
            db.cancel_migration(org_id, cur)


def _make_env():
    env = {"db": Database(settings().tractor_disk_db)}
    return env
