from typing import Final, List
from contextlib import closing

from tractor.mail.models import UserMigrationExportInfo
from tractor.mail.db import Database


_HEADER_LINE: Final = "login,status,error_reason,external_mailbox_messages_count,collected_messages_count,failed_to_collect_messages_count\n"


def export_user_migrations(org_id: str, db: Database) -> List[UserMigrationExportInfo]:
    with closing(db.make_connection()) as conn, conn, conn.cursor() as cur:
        return db.export_user_migrations(org_id, cur=cur)


def render_export_csv(users: List[UserMigrationExportInfo]) -> str:
    return _HEADER_LINE + "".join(map(_export_info_to_csv_line, users))


def _export_info_to_csv_line(user: UserMigrationExportInfo) -> str:
    return (
        f'{user.login},{user.status.value},"{user.error_reason}"'
        f",{user.mailbox_messages_collection_stats.source_count if user.mailbox_messages_collection_stats else ''}"
        f",{user.mailbox_messages_collection_stats.collected_count if user.mailbox_messages_collection_stats else ''}"
        f",{user.mailbox_messages_collection_stats.failed_count if user.mailbox_messages_collection_stats else ''}"
        "\n"
    )
